<?php
require __DIR__ . '/vendor/autoload.php';

use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;

// ——— Ayarlar ——————————————————
const LIST_URL    = 'https://m.sahibinden.com/emlak?address_country=270';
const LINK_CACHE  = __DIR__ . '/detailLinks.json';
const OUTPUT_FILE = __DIR__ . '/agents.json';

// Kendi proxy listen:
$proxies = [
    '198.23.239.134:6540:xpfgnfly:aapbjxp7camk',
    '207.244.217.165:6712:xpfgnfly:aapbjxp7camk',
    '107.172.163.27:6543:xpfgnfly:aapbjxp7camk',
    '161.123.152.115:6360:xpfgnfly:aapbjxp7camk',
    '23.94.138.75:6349:xpfgnfly:aapbjxp7camk',
];

// Helper: sıradaki proxy’yi döndür
$pi = 0;
function getProxy(array $list): array {
    global $pi;
    $item = $list[$pi % count($list)];
    $pi++;
    list($ip, $port, $user, $pass) = explode(':', $item, 4);
    return [
        'base' => "{$ip}:{$port}",
        'auth' => "{$user}:{$pass}"
    ];
}

// Mobile UA taklidi
$userAgent = 'Mozilla/5.0 (iPhone; CPU iPhone OS 14_0 like Mac OS X) '.
    'AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0 Mobile/15E148 Safari/604.1';

// 1) Detay linkleri cache’e al
if (!file_exists(LINK_CACHE)) {
    $all = [];
    for ($p=0; $p<3; $p++) {
        $offset = $p*20;
        $cfg    = getProxy($proxies);
        echo "Sayfa " . ($p+1) . " — Proxy: {$cfg['base']}\n";
        $client = new Client([
            'headers' => ['User-Agent'=>$userAgent],
            'proxy'   => [
                'http'  => "http://{$cfg['auth']}@{$cfg['base']}",
                'https' => "http://{$cfg['auth']}@{$cfg['base']}",
            ],
            'timeout' => 15
        ]);
        $res = $client->get(LIST_URL . '&pagingOffset=' . $offset);
        $crawler = new Crawler((string)$res->getBody());
        $crawler->filter('div.searchResultsItem a.title')->each(function(Crawler $node) use(&$all){
            $href = $node->attr('href');
            $all[] = 'https://m.sahibinden.com' . $href;
        });
        sleep(1);
    }
    $all = array_unique($all);
    file_put_contents(LINK_CACHE, json_encode($all, JSON_PRETTY_PRINT));
    echo "➤ Cache: " . count($all) . " ilan linki\n";
}
$detailLinks = json_decode(file_get_contents(LINK_CACHE), true);

// 2) Her ilan → acente sayfası → parse
$results = [];
foreach ($detailLinks as $url) {
    if (count($results)>=5) break; // 5 test
    $cfg    = getProxy($proxies);
    echo "▶ İlan: {$url} — Proxy: {$cfg['base']}\n";
    $client = new Client([
        'headers'=>['User-Agent'=>$userAgent],
        'proxy'=>[
            'http'=>"http://{$cfg['auth']}@{$cfg['base']}",
            'https'=>"http://{$cfg['auth']}@{$cfg['base']}",
        ],
        'timeout'=>15
    ]);
    try {
        // Detay → acente link
        $res1 = $client->get($url);
        $c1   = new Crawler((string)$res1->getBody());
        $lnk  = $c1->filter('a.contactSeller')->first();
        if (!$lnk->count()) {
            echo "  ⚠️ Acente linki bulunamadı\n";
            continue;
        }
        $agentUrl = 'https://m.sahibinden.com' . $lnk->attr('href');
        echo "  → Acente: {$agentUrl}\n";

        // Acente sayfa
        $res2 = $client->get($agentUrl);
        $c2   = new Crawler((string)$res2->getBody());
        $agencyName = trim($c2->filter('h1.store-name')->text(''));
        $location   = trim($c2->filter('div.store-name')->attr('data-main-location',''));

        // Ekip sayfa
        $res3 = $client->get(rtrim($agentUrl,'/').'/ekibimiz');
        $c3   = new Crawler((string)$res3->getBody());
        $team = [];
        $c3->filter('div.team-member')->each(function(Crawler $card) use(&$team){
            $n = trim($card->filter('p.name')->text(''));
            $t = trim($card->filter('p.title')->text(''));
            $p = trim($card->filter('a.phone')->attr('data-phone',''));
            $team[] = ['name'=>$n,'tag'=>$t,'phone'=>$p];
        });

        $results[] = [
            'agentUrl'=>$agentUrl,
            'agencyName'=>$agencyName,
            'location'=>$location,
            'team'=>$team
        ];
    } catch (\Throwable $e) {
        echo "  ❌ Hata: " . $e->getMessage() . "\n";
        continue;
    }
    sleep(1);
}

// Sonuçları yaz
file_put_contents(OUTPUT_FILE,
    json_encode($results, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)
);
echo "✅ Sonuç: " . OUTPUT_FILE . "\n";
