// scroll-fetch.js
const puppeteer = require('puppeteer');

(async () => {
  const url = 'https://m.sahibinden.com/emlak?address_country=270';
  const browser = await puppeteer.launch({ headless: true });
  const page = await browser.newPage();
  await page.setUserAgent('Mozilla/5.0 (Linux; Android 10; Mobile)');
  await page.goto(url, { waitUntil: 'networkidle2' });

  // 1. Sayfayı sonuna kadar kaydırarak tüm ilanları yükle
  let previousHeight;
  while (true) {
    previousHeight = await page.evaluate('document.body.scrollHeight');
    await page.evaluate('window.scrollTo(0, document.body.scrollHeight)');
    await new Promise(r => setTimeout(r, 1500));  // yükleme için bekle
    const newHeight = await page.evaluate('document.body.scrollHeight');
    if (newHeight === previousHeight) break;
  }

  // 2. Artık tüm ilan linkleri DOM'da var; seçiciyi güncelleyin:
  const links = await page.$$eval(
    'a[href*="/ilan/"]',
    els => els.map(a => a.href)
  );
  console.log(Array.from(new Set(links)));  // benzersiz liste

  await browser.close();
})();
