// puppeteer-fetch.js
const puppeteer = require('puppeteer');

(async () => {
  const base = 'https://m.sahibinden.com/emlak?address_country=270';
  let allLinks = [];

  const browser = await puppeteer.launch({ headless: true });
  const page    = await browser.newPage();
  // Mobil UA taklidi
  await page.setUserAgent(
    'Mozilla/5.0 (Linux; Android 10; Mobile) AppleWebKit/537.36 Chrome/83.0.4103.106 Mobile Safari/537.36'
  );

  for (let p = 1; p <= 10; p++) {
    const url = `${base}&pagingOffset=${(p - 1) * 20}`;
    console.error(`Loading mobile page ${p}: ${url}`);
    await page.goto(url, { waitUntil: 'networkidle2' });

    // Evvelce bekleme: artık page.waitFor yerine aşağıyı kullanıyoruz
    await new Promise(resolve => setTimeout(resolve, 1000));

    // Mobil sayfasında ilan linkleri `a[data-testid="search-result-title"]`
    const links = await page.$$eval(
      'a[data-testid="search-result-title"]',
      els => els.map(a => a.href)
    );
    console.error(`  → Found ${links.length} links on page ${p}`);
    allLinks.push(...links);
  }

  await browser.close();

  const unique = Array.from(new Set(allLinks));
  console.error(`➤ ${unique.length} unique detail links collected\n`);
  console.log(JSON.stringify(unique));
})();
