<?php
// property_detail.php
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: properties.php');
    exit;
}
$propId = (int)$_GET['id'];

// 1) DB Bağlantısı
$pdo = new PDO('mysql:host=localhost;dbname=emlak_db;charset=utf8mb4', 'root', '', [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);

// 2) Emlak bilgisi
$stmt = $pdo->prepare("SELECT title, address, price, description FROM properties WHERE id = ?");
$stmt->execute([$propId]);
$property = $stmt->fetch();
if (!$property) {
    die('<div class="alert alert-warning m-4">Emlak bulunamadı.</div>');
}

// 3) Acenteler & Ekip üyeleri
$sql = "
  SELECT 
    a.id AS agent_id,
    a.agency_name,
    a.location AS agent_location,
    tm.name AS member_name,
    tm.tag AS member_tag,
    tm.phone AS member_phone
  FROM agents a
  JOIN properties_agents pa ON pa.agent_id = a.id
  LEFT JOIN team_members tm ON tm.agent_id = a.id
  WHERE pa.property_id = ?
  ORDER BY a.agency_name, tm.name
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$propId]);
$rows = $stmt->fetchAll();

// DataTables için JSON formatına çevir
$data = [];
foreach ($rows as $r) {
    $data[] = [
        'agency'   => $r['agency_name'],
        'location' => $r['agent_location'],
        'member'   => $r['member_name'] ?: '-',
        'tag'      => $r['member_tag'] ?: '-',
        'phone'    => $r['member_phone'] ?: '-',
    ];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <title>Emlakçı Bilgileri – <?= htmlspecialchars($property['title']) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap 5 + DataTables CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>
<body>
  <div class="container py-4">
    <a href="properties.php" class="btn btn-secondary mb-3">&larr; Geri Dön</a>
    <h2><?= htmlspecialchars($property['title']) ?></h2>
    <p>
      <strong>Adres:</strong> <?= htmlspecialchars($property['address']) ?><br>
      <strong>Fiyat:</strong> <?= number_format($property['price'],0,',','.') ?> ₺
    </p>
    <p><?= nl2br(htmlspecialchars($property['description'])) ?></p>

    <hr>

    <h4>Acenteler ve Ekip Üyeleri</h4>
    <table id="agentsTable" class="table table-striped" style="width:100%">
      <thead>
        <tr>
          <th>Acenta</th>
          <th>Konum</th>
          <th>Üye Adı</th>
          <th>Üye Tag</th>
          <th>Telefon</th>
        </tr>
      </thead>
      <tbody>
        <!-- DataTables JS ile doldurulacak -->
      </tbody>
    </table>
  </div>

  <!-- JS: Bootstrap, jQuery, DataTables -->
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
  <script>
    const dataSet = <?= json_encode($data, JSON_UNESCAPED_UNICODE) ?>;

    $(document).ready(function() {
      $('#agentsTable').DataTable({
        data: dataSet,
        columns: [
          { data: 'agency' },
          { data: 'location' },
          { data: 'member' },
          { data: 'tag' },
          { data: 'phone' }
        ],
        language: {
          url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/tr.json'
        },
        lengthMenu: [5,10,25,50],
        pageLength: 10
      });
    });
  </script>
</body>
</html>
