<?php
// properties.php

// 1) DB Bağlantısı
$pdo = new PDO('mysql:host=localhost;dbname=emlak_db;charset=utf8mb4', 'root', '', [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);

// 2) Emlak verilerini çek
$sql = "SELECT id, title, address, price, thumbnail_url FROM properties ORDER BY created_at DESC";
$properties = $pdo->query($sql)->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <title>Emlak Listesi</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f3f6f9; }
    .card { cursor: pointer; transition: transform .2s; }
    .card:hover { transform: scale(1.03); }
    .card-img-top { height: 180px; object-fit: cover; }
  </style>
</head>
<body>
  <div class="container py-4">
    <h1 class="mb-4">Emlak Listesi</h1>
    <div class="row g-3">
      <?php foreach($properties as $prop): ?>
      <div class="col-lg-4 col-md-6">
        <div class="card h-100" onclick="location.href='property_detail.php?id=<?= $prop['id'] ?>'">
          <img src="<?= htmlspecialchars($prop['thumbnail_url']) ?>" class="card-img-top" alt="<?= htmlspecialchars($prop['title']) ?>">
          <div class="card-body">
            <h5 class="card-title"><?= htmlspecialchars($prop['title']) ?></h5>
            <p class="card-text">
              <strong>Adres:</strong> <?= htmlspecialchars($prop['address']) ?><br>
              <strong>Fiyat:</strong> <?= number_format($prop['price'],0,',','.') ?> ₺
            </p>
          </div>
        </div>
      </div>
      <?php endforeach ?>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
