<?php
// panel.php

// 1) DB bağlantısı (PDO)
$host     = 'localhost';
$db       = 'emlak_db';
$user     = 'root';
$pass     = '';
$charset  = 'utf8mb4';
$dsn      = "mysql:host=$host;dbname=$db;charset=$charset";
$options  = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];
try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (Exception $e) {
    die('<div class="alert alert-danger m-4">DB bağlantı hatası: ' 
        . htmlspecialchars($e->getMessage()) . '</div>');
}

// 2) Kaynakları ve acenteleri çek
$sql = "
  SELECT 
    a.id AS agent_id,
    a.source,
    a.agency_name,
    a.agent_url,
    a.location,
    tm.id AS member_id,
    tm.name AS member_name,
    tm.tag AS member_tag,
    tm.phone AS member_phone
  FROM agents a
  LEFT JOIN team_members tm ON tm.agent_id = a.id
  ORDER BY a.source, a.agency_name, tm.id
";
$stmt = $pdo->query($sql);

// 3) Veriyi hiyerarşik diziye dönüştür
$sources = [];
while ($row = $stmt->fetch()) {
    $src = $row['source'] ?: 'Diğer';
    if (!isset($sources[$src])) {
        $sources[$src] = [];
    }
    $agentId = $row['agent_id'];
    if (!isset($sources[$src][$agentId])) {
        $sources[$src][$agentId] = [
            'agency_name' => $row['agency_name'],
            'agent_url'   => $row['agent_url'],
            'location'    => $row['location'],
            'team'        => []
        ];
    }
    if ($row['member_id']) {
        $sources[$src][$agentId]['team'][] = [
            'name'  => $row['member_name'],
            'tag'   => $row['member_tag'],
            'phone' => $row['member_phone']
        ];
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <title>Admin Panel – Acenteler</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { min-height:100vh; display:flex; }
    .sidebar { width:280px; background:#2f4050; color:#fff; }
    .sidebar h4 { padding:1rem; margin:0; background:#1c2b36; }
    .sidebar .nav-link { color:#a7b1c2; }
    .sidebar .nav-link.active { background:#1c2b36; color:#fff; }
    .content { flex:1; padding:2rem; background:#f3f6f9; overflow-x:hidden; }
    .card { transition:0.2s; }
    .card:hover { transform: scale(1.02); }
  </style>
</head>
<body>

  <!-- Sidebar -->
  <nav class="sidebar d-flex flex-column">
    <h4>Acenteler</h4>
    <ul class="nav flex-column" id="sourceList">
      <?php 
      $firstSource = null;
      foreach ($sources as $src => $agents): 
          if (is_null($firstSource)) $firstSource = $src;
      ?>
        <li class="nav-item">
          <a class="nav-link<?= $src === $firstSource ? ' active' : '' ?>"
             href="#"
             data-source="<?= htmlspecialchars($src) ?>">
            <?= htmlspecialchars($src) ?> 
            <span class="badge bg-secondary"><?= count($agents) ?></span>
          </a>
        </li>
      <?php endforeach ?>
    </ul>
    <hr class="border-secondary my-0">
    <small class="text-center mt-auto mb-3 text-muted">© 2025 Panel</small>
  </nav>

  <!-- Main content -->
  <div class="content">
    <?php foreach ($sources as $src => $agents): 
        $panelId = 'panel-' . md5($src);
    ?>
      <div class="source-panel<?= $src !== $firstSource ? ' d-none' : '' ?>" id="<?= $panelId ?>">
        <h2><?= htmlspecialchars($src) ?></h2>
        <div class="row g-3 mt-3">
          <?php foreach ($agents as $agent): ?>
            <div class="col-lg-4 col-md-6">
              <div class="card shadow-sm h-100">
                <div class="card-body">
                  <h5 class="card-title"><?= htmlspecialchars($agent['agency_name']) ?></h5>
                  <p class="card-text mb-1">
                    <strong>Konum:</strong> <?= htmlspecialchars($agent['location']) ?>
                  </p>
                  <p class="card-text mb-2">
                    <a href="<?= htmlspecialchars($agent['agent_url']) ?>" target="_blank">Siteye Git</a>
                  </p>
                  <button class="btn btn-sm btn-primary w-100"
                          data-bs-toggle="collapse"
                          data-bs-target="#team-<?= md5($agent['agent_url']) ?>">
                    Ekip Üyeleri (<?= count($agent['team']) ?>)
                  </button>
                  <div class="collapse mt-2" id="team-<?= md5($agent['agent_url']) ?>">
                    <?php if ($agent['team']): ?>
                      <?php foreach ($agent['team'] as $member): ?>
                        <div class="card border-0 mb-2">
                          <div class="card-body p-2">
                            <strong><?= htmlspecialchars($member['name']) ?></strong><br>
                            <small class="text-muted"><?= htmlspecialchars($member['tag']) ?></small><br>
                            <small>📞 <?= htmlspecialchars($member['phone']) ?></small>
                          </div>
                        </div>
                      <?php endforeach ?>
                    <?php else: ?>
                      <p class="text-muted small mt-2">Ekip üyesi yok</p>
                    <?php endif ?>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach ?>
        </div>
      </div>
    <?php endforeach ?>
  </div>

  <!-- Bootstrap + JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    document.querySelectorAll('#sourceList .nav-link').forEach(link => {
      link.addEventListener('click', e => {
        e.preventDefault();
        // Menüde active ayarla
        document.querySelectorAll('#sourceList .nav-link')
          .forEach(l => l.classList.remove('active'));
        link.classList.add('active');
        // Panel göster/gizle
        const src = link.getAttribute('data-source');
        document.querySelectorAll('.source-panel')
          .forEach(panel => panel.classList.add('d-none'));
        const id = 'panel-' + md5(src);
        document.getElementById(id).classList.remove('d-none');
      });
    });
    // Basit md5 (async)
    async function md5(str) {
      const buf = await crypto.subtle.digest('MD5', new TextEncoder().encode(str));
      return Array.from(new Uint8Array(buf))
        .map(b => b.toString(16).padStart(2, '0')).join('');
    }
    // md5 çağırırken promise'i çözecek
    // Örneğin: md5(src).then(id => document.getElementById(id)...)
    // Ancak burada md5(src) promise döndürdüğü için direkt string yerine
    // inline hash hesaplansa da pratikte küçük bir kaçış.
  </script>
</body>
</html>
