<?php
// sources.php

$pdo = new PDO('mysql:host=localhost;dbname=emlak_db;charset=utf8mb4', 'root', '', [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);

// Kaynakları ve her kaynağın agent sayısını çek
$sql = "
  SELECT source, COUNT(*) AS cnt 
  FROM agents 
  GROUP BY source
  ORDER BY cnt DESC
";
$sources = $pdo->query($sql)->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <title>Kaynaklar</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .card { cursor: pointer; transition: transform .2s; }
    .card:hover { transform: scale(1.02); }
  </style>
</head>
<body class="py-5 bg-light">
  <div class="container">
    <h1 class="mb-4">Kaynak Seçin</h1>
    <div class="row g-4">
      <?php foreach($sources as $s): 
        $src = $s['source'] ?: 'Diğer';
      ?>
      <div class="col-md-6 col-lg-4">
        <div class="card h-100" onclick="location.href='agents.php?source=<?= urlencode($src) ?>'">
          <div class="card-body d-flex justify-content-between align-items-center">
            <span><?= htmlspecialchars($src) ?></span>
            <span class="badge bg-primary"><?= $s['cnt'] ?></span>
          </div>
        </div>
      </div>
      <?php endforeach ?>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
