// generate_detail_links.js
require('dotenv').config();
const fs        = require('fs');
const path      = require('path');
const readline  = require('readline');
const puppeteer = require('puppeteer-extra');
const Stealth   = require('puppeteer-extra-plugin-stealth');
puppeteer.use(Stealth());

const {
  PROXIES_FILE,
  MAX_PAGES,
  PER_PAGE,
  NAV_TIMEOUT,
} = process.env;

const OUTPUT_PATH   = path.resolve(__dirname, 'detailLinks.json');
const PROGRESS_PATH = path.resolve(__dirname, 'linkProgress.json');
const BASE_URL      = 'https://www.sahibinden.com/emlak';

function delay(ms){ return new Promise(r=>setTimeout(r,ms)); }
async function waitENTER(msg){
  process.stdout.write(msg||'');
  await new Promise(r=>{
    readline.createInterface({ input: process.stdin, output: process.stdout })
      .question('', ()=>r());
  });
}

// proxy listesi oku
const proxyLines = fs.readFileSync(PROXIES_FILE,'utf8')
  .split(/\r?\n/).filter(l=>l.trim());
let proxyIdx = 0;
function nextProxy(){
  const [host,port,user,pass] = proxyLines[proxyIdx].split(':');
  proxyIdx = (proxyIdx+1)%proxyLines.length;
  return { host, port, user, pass };
}

;(async()=>{
  // kaldığınız sayfayı al
  let lastPage = 0;
  if (fs.existsSync(PROGRESS_PATH)){
    ({ lastPage } = JSON.parse(fs.readFileSync(PROGRESS_PATH,'utf8')));
  }
  console.log(`▶ Önceki son sayfa: ${lastPage}`);

  let allLinks = new Set(
    fs.existsSync(OUTPUT_PATH)
      ? JSON.parse(fs.readFileSync(OUTPUT_PATH,'utf8'))
      : []
  );

  for(let i=lastPage; i<MAX_PAGES; i++){
    const off = i*PER_PAGE;
    const url = `${BASE_URL}?address_country=270&pagingOffset=${off}`;
    console.log(`▶ Sayfa ${i+1}/${MAX_PAGES}: ${url}`);

    // her sayfa için yeni tarayıcı başlat (proxy rotasyonu)
    const pr = nextProxy();
    const browser = await puppeteer.launch({
      headless: true,
      args:[
        `--proxy-server=${pr.host}:${pr.port}`
      ]
    });
    const page = await browser.newPage();
    if(pr.user){
      await page.authenticate({ username: pr.user, password: pr.pass });
    }

    try {
      await page.goto(url, { timeout: +NAV_TIMEOUT, waitUntil:'networkidle2' });
    } catch(e){
      console.warn('  ⚠️ Timeout ya da hata, devam ediliyor…');
    }
    if (page.url().includes('secure.sahibinden.com')){
      await waitENTER('⚠️ Cloudflare doğrulama: ENTER basınca devam edilecek…');
    }
    await delay(2000 + Math.random()*1000);

    const links = await page.$$eval(
      'tr.searchResultsItem a.classifiedTitle',
      els=>els.map(a=>a.href)
    ).catch(()=>[]);
    console.log(`  → Buldu: ${links.length}`);

    links.forEach(h=>allLinks.add(h));
    fs.writeFileSync(OUTPUT_PATH, JSON.stringify([...allLinks],null,2));
    fs.writeFileSync(PROGRESS_PATH, JSON.stringify({ lastPage: i+1 }), 'utf8');

    await browser.close();
    await delay(500 + Math.random()*500);
  }

  console.log(`✅ Toplam ${allLinks.size} eşsiz link kaydedildi.`);
  process.exit(0);
})();
