<?php
// display_agents.php

$jsonFile = __DIR__ . '/test_agents.json';

if (!file_exists($jsonFile)) {
    die('<div class="alert alert-danger m-4">Error: <code>test_agents.json</code> bulunamadı.</div>');
}

$data = json_decode(file_get_contents($jsonFile), true);
if (!is_array($data)) {
    die('<div class="alert alert-danger m-4">Error: Geçersiz JSON formatı.</div>');
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <title>Test Agents</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-4">
    <h1 class="mb-4 text-primary">Sahibinden</h1>
    <div class="accordion" id="sahibindenAccordion">
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingAcenteler">
          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                  data-bs-target="#collapseAcenteler" aria-expanded="true"
                  aria-controls="collapseAcenteler">
            Acenteler
          </button>
        </h2>
        <div id="collapseAcenteler" class="accordion-collapse collapse show"
             aria-labelledby="headingAcenteler" data-bs-parent="#sahibindenAccordion">
          <div class="accordion-body">
            <div class="accordion" id="acenteAccordion">
              <?php foreach ($data as $i => $agent): ?>
                <div class="accordion-item">
                  <h2 class="accordion-header" id="headingAgent<?= $i ?>">
                    <button class="accordion-button collapsed" type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#collapseAgent<?= $i ?>"
                            aria-expanded="false"
                            aria-controls="collapseAgent<?= $i ?>">
                      <?= htmlspecialchars($agent['agencyName']) ?>
                      <small class="text-muted"> (<?= htmlspecialchars($agent['location']) ?>)</small>
                    </button>
                  </h2>
                  <div id="collapseAgent<?= $i ?>" class="accordion-collapse collapse"
                       aria-labelledby="headingAgent<?= $i ?>"
                       data-bs-parent="#acenteAccordion">
                    <div class="accordion-body">
                      <p class="mb-2">
                        <strong>Acenta URL:</strong>
                        <a href="<?= htmlspecialchars($agent['agentUrl']) ?>" target="_blank"
                           class="link-primary">
                          <?= htmlspecialchars($agent['agentUrl']) ?>
                        </a>
                      </p>
                      <h5 class="mt-3 mb-2">Ekip Üyeleri</h5>
                      <?php if (!empty($agent['team'])): ?>
                        <div class="row g-3">
                          <?php foreach ($agent['team'] as $member): ?>
                            <div class="col-md-4">
                              <div class="card h-100 shadow-sm">
                                <div class="card-body">
                                  <h6 class="card-title"><?= htmlspecialchars($member['name']) ?></h6>
                                  <p class="card-text mb-1">
                                    <strong>Unvan:</strong> <?= htmlspecialchars($member['tag']) ?>
                                  </p>
                                  <p class="card-text">
                                    <strong>Telefon:</strong> <?= htmlspecialchars($member['phone']) ?>
                                  </p>
                                </div>
                              </div>
                            </div>
                          <?php endforeach ?>
                        </div>
                      <?php else: ?>
                        <p class="text-muted fst-italic">Takım bilgisi yok</p>
                      <?php endif ?>
                    </div>
                  </div>
                </div>
              <?php endforeach ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap 5 Bundle (JS + Popper) -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
