<?php
// agents.php

// 1) Gelen source kontrolü
if (empty($_GET['source'])) {
    header('Location: sources.php');
    exit;
}
$source = $_GET['source'];

// 2) DB Bağlantısı
$pdo = new PDO('mysql:host=localhost;dbname=emlak_db;charset=utf8mb4', 'root', '', [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);

// 3) Bu kaynağa ait acenteleri çek
$stmt = $pdo->prepare("
    SELECT id, agency_name, location 
    FROM agents 
    WHERE source = ?
    ORDER BY agency_name
");
$stmt->execute([$source]);
$agents = $stmt->fetchAll();

// 4) Eğer hiç acente yoksa kullanıcıyı geri gönder
if (!$agents) {
    echo '<div class="alert alert-warning m-4">Bu kaynağa ait acente bulunamadı.</div>';
    echo '<p class="m-4"><a href="index.php">&larr; Kaynak seçmeye dön</a></p>';
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <title><?= htmlspecialchars($source) ?> – Acenteler</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .card { cursor: pointer; transition: transform .2s; }
    .card:hover { transform: scale(1.02); }
  </style>
</head>
<body class="py-5 bg-light">
  <div class="container">
    <h1 class="mb-4">
      Kaynak: <strong><?= htmlspecialchars($source) ?></strong>
    </h1>
    <div class="row g-4">
      <?php foreach($agents as $a): ?>
      <div class="col-md-6 col-lg-4">
<div class="card h-100"
      onclick="location.href='agent_detail.php?agent_id=<?= $a['id'] ?>&source=<?= urlencode($source) ?>'">
          <div class="card-body">
            <h5 class="card-title"><?= htmlspecialchars($a['agency_name']) ?></h5>
            <p class="card-text mb-0">
              <i class="bi bi-geo-alt-fill"></i>
              <?= htmlspecialchars($a['location']) ?>
            </p>
          </div>
        </div>
      </div>
      <?php endforeach ?>
    </div>
    <p class="mt-4">
      <a href="index.php" class="btn btn-outline-secondary">&larr; Başka kaynağa dön</a>
    </p>
  </div>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
