<?php
// agent_detail.php

// 1) Gelen ID kontrolü
if (empty($_GET['agent_id']) || !ctype_digit($_GET['agent_id'])) {
    header('Location: sources.php');
    exit;
}
$agent_id = (int)$_GET['agent_id'];

// 1b) Gelen source (isteğe bağlı)
$source = isset($_GET['source']) ? $_GET['source'] : null;

// 2) DB Bağlantısı
$pdo = new PDO('mysql:host=localhost;dbname=emlak_db;charset=utf8mb4', 'root', '', [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);

// 3) Acentenin detayları
$stmt = $pdo->prepare("SELECT agency_name, location, agent_url FROM agents WHERE id = ?");
$stmt->execute([$agent_id]);
$agent = $stmt->fetch();
if (!$agent) {
    die('<div class="alert alert-danger m-4">Acenteye ulaşılamadı.</div>');
}

// 4) Ekip üyelerini çek
$stmt = $pdo->prepare("
    SELECT name, tag, phone 
    FROM team_members 
    WHERE agent_id = ?
    ORDER BY name
");
$stmt->execute([$agent_id]);
$team = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <title><?= htmlspecialchars($agent['agency_name']) ?> – Ekip Üyeleri</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <!-- Bootstrap + DataTables CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>
<body class="py-5">
  <div class="container">
    <h1 class="mb-4">
      <?= htmlspecialchars($agent['agency_name']) ?>  
      <small class="text-muted fs-6">– <?= htmlspecialchars($agent['location']) ?></small>
    </h1>

    <table id="teamTable" class="table table-striped table-bordered">
      <thead>
        <tr>
          <th>İsim</th>
          <th>Pozisyon</th>
          <th>Telefon</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($team as $m): ?>
        <tr>
          <td><?= htmlspecialchars($m['name']) ?></td>
          <td><?= htmlspecialchars($m['tag']) ?></td>
          <td><?= htmlspecialchars($m['phone']) ?></td>
        </tr>
        <?php endforeach ?>
      </tbody>
    </table>

    <!-- Geri Dön butonu -->
    <?php if ($source): ?>
      <a href="agents.php?source=<?= urlencode($source) ?>" 
         class="btn btn-secondary mt-3">&larr; Geri Dön</a>
    <?php else: ?>
      <a href="sources.php" class="btn btn-secondary mt-3">&larr; Kaynaklara Dön</a>
    <?php endif ?>
  </div>

  <!-- JS: jQuery, Bootstrap, DataTables -->
  <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
  <script>
    $(document).ready(function(){
      $('#teamTable').DataTable({
        language: {
          url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/tr.json'
        },
        pageLength: 10,
        lengthChange: false
      });
    });
  </script>
</body>
</html>
